@extends('layouts.user')

{{-- Web site Title --}}

<style>
    button {
        display: block;
        border: solid white;
        border-width: 0 10px;
        border-radius: 0;
        background: green;
        color: white;
        font-size: 18px;
        margin: -60px auto 15px;
        padding: 15px;
    }

    .dropdown {
        position: absolute;
        display: inline-block;
    }

    .dropdown-content {
        display: none;
        position: absolute;
        background-color: #f1f1f1;
        min-width: 160px;
        z-index: 1;
    }

    .dropdown-content a {
        color: black;
        padding: 12px 16px;
        text-decoration: none;
        display: block;
    }

    .dropdown-content a:hover {
        background-color: #ddd
    }

    .dropdown:hover .dropdown-content {
        display: block;
    }

    .btn:hover,
    .dropdown:hover .btn {
        background-color: #0b7dda;
    }
</style>
{{-- Content --}}
@section('content')
<div class="panel panel-default">
    <div class="panel-heading">
        <h4 class="panel-title">
            <i class="material-icons">format_list_numbered_rtl</i>
            {{ 'All Packages ' }}
        </h4>
        <span class="pull-right"><i class="fa fa-fw fa-chevron-up clickable"></i></span>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="data_data" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#. </th>
                        <th>Name</th>
                        <th>No. of Services</th>
                        <th>Actual Price</th>
                        <th>Discount</th>
                        <th>Discounted Price</th>
                        <th>Status</th>
                        <!-- <th>Actions</th> -->

                        <!-- <th>Price </th> -->
                        <th>{{ trans('table.actions') }}</th>

                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
    @stop
    @section('scripts')




    <script type="text/javascript" language="javascript">
        $(document).ready(function() {

            $(function() {
                $('#data_data').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "index/data",
                        type: "GET"
                    },
                    columns: [

                        {
                            render: (data, type, row, meta) => meta.row + 1,
                        },

                        {
                            data: 'name_en',
                        },
                        {
                            data: 'no_of_services',
                        },

                        {
                            data: 'actual_price',
                        },



                        {
                            data: 'discount',
                        },

                        {
                            data: 'discounted_price',
                        },
                        {
                            data: 'status',
                        },


                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }




                    ]
                });
            });

        });
    </script>

    @stop