<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Services;
use Illuminate\Contracts\Session\Session;
use Illuminate\Http\Request;
use  Datatables;

use  Sentinel;

class ServicesController extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->where('id', Sentinel::getUser()->id)->get()->first();
    }






    public   function insert(Request  $request)
    {


        $title = 'Create New Service';
        // $title = trans('quotation.quotations');

        Services::create($request->all());
        Session()->flash('flash_message', 'Created Successfully');
        return $this->index($request);
    } //insert
    public   function create(Request  $request)
    {
        $title = 'Create New Service';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return view('services.create', compact('user_data', 'title'));
    } //create


    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('services.index', compact('user_data'));
    } //index

    public function anyData()
    {
        $data = Services::select(['*'])->where([['isActive', 1], ['isDeleted', 0]])->orderBy('id', 'DESC')->get();
        // return $this->getTable($clients);
        return Datatables::of($data)


            ->addColumn('status', function ($data) {
                if ($data->isActive == 1)
                    return 'Active';
                else if ($data->isActive == 2)
                    return 'In Active';
            })
            ->add_column(
                'action',

                '
            <div class="dropdown">
              <button class="btn" style="border-left:1px solid #0d8bf2">Actions
  
              </button>
              <div class="dropdown-content">
              <a href="#">View</a> 
              <a href="#">Delete</a>
              </div>
            </div>'
            )





            // ->add_column('id', $clients->id)
            // ->add_column('price', $clients->id)
            // ->add_column('delete', '
            //     <form action="{{ route(\'clients.destroy\', $id) }}" method="POST">
            // <input type="hidden" name="_method" value="DELETE">
            // <input type="submit" name="submit" value="Delete" class="btn btn-danger" onClick="return confirm(\'Are you sure?\')"">

            // {{csrf_field()}}
            // </form>')
            ->make(true);
    }

    //
}
