<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\New_customers;
use App\Packages;
use App\Services;
use App\Services_assigned_packages;
use Exception;
use Illuminate\Http\Request;
use  Sentinel;

use Datatables;

class PackagesController extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->where('id', Sentinel::getUser()->id)->get()->first();
    }

    public   function create(Request  $request)
    {
        $title = 'Add New Package';
        $user_data = $this->get_user_info();
        $services = Services::select(['*'])->where([['isActive', 1], ['isDeleted', 0]])->get();
        $packages = Packages::select(['name_en', 'id'])->get();

        // $title = trans('quotation.quotations');
        return view('packages.create', compact('user_data', 'title', 'services', 'packages'));
    } //create
    public function get_details(Request $request)
    {
        // return $request->all();
        $info = Packages::select(['*'])->join('services_assigned_packages', 'services_assigned_packages.package_id', 'packages.id')->where('packages.id', $request->id)->get();
        return $info;
    } //get_details
    public   function insert(Request  $request)
    {
        $input_package = array_merge(
            // $request->all(),
            [
                'name_en' => $request->name_en,
                'name_ar' => $request->name_ar,
                'actual_price' => $request->actual_price,
                'discounted_price' => $request->discounted_price,
                'discount' => $request->discount,
                'terms_and_conditions' => $request->terms_and_conditions,
                'created_by' =>  Sentinel::getUser()->id,
                'no_of_services' => count($request->id)
            ]
        );


        $package = Packages::create($input_package);
        $customer = null;

        for ($x = 0; $x < count($request->id); $x++) {


            $services_input = array_merge(
                // $request->all(),
                [
                    'package_id' => $package->id,
                    'services_id' => $request->id[$x],


                ]
            );
            Services_assigned_packages::create($services_input);
        }




        Session()->flash('flash_message', 'Created Successfully');
        return $this->index($request);
    } //insert
    //

    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('packages.index', compact('user_data'));
    } //index

    public function anyData()
    {
        $data = Packages::select(['*'])->where([['status', '!=', 3]])->orderBy('id', 'DESC')->get();
        // return $this->getTable($clients);
        return Datatables::of($data)
            ->editColumn('discount', function ($data) {
                return $data->discount . ' OMR';
            })
            ->editColumn('actual_price', function ($data) {
                return $data->actual_price . ' OMR';
            })
            ->editColumn('discounted_price', function ($data) {
                return $data->discounted_price . ' OMR';
            })

            ->addColumn('status', function ($data) {
                if ($data->status == 1)
                    return 'Active';
                else if ($data->status == 2)
                    return 'In Active';
            })
            ->add_column(
                'action',

                '
            <div class="dropdown">
              <button class="btn" style="border-left:1px solid #0d8bf2">Actions
  
              </button>
              <div class="dropdown-content">
              <a href="#">View</a> 
              <a href="#">Delete</a>
              </div>
            </div>'
            )





            // ->add_column('id', $clients->id)
            // ->add_column('price', $clients->id)
            // ->add_column('delete', '
            //     <form action="{{ route(\'clients.destroy\', $id) }}" method="POST">
            // <input type="hidden" name="_method" value="DELETE">
            // <input type="submit" name="submit" value="Delete" class="btn btn-danger" onClick="return confirm(\'Are you sure?\')"">

            // {{csrf_field()}}
            // </form>')
            ->make(true);
    }
}
