<?php

namespace App\Http\Controllers;

use App\Expense_types;
use Illuminate\Http\Request;

use App\Models\User;
use App\New_customers;
use App\New_qoutation_services;
use App\New_qoutations;
use App\Packages;
use App\Services;
use  Sentinel;

use Datatables;
use Exception;

class NewQoutationsController extends Controller
{

    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->where('id', Sentinel::getUser()->id)->get()->first();
    }

    public   function create(Request  $request)
    {
        $packages = Packages::select(['name_en', 'id'])->get();
        $services = Services::select(['*'])->get();

        $title = 'Create New Qoutation';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return view('new_qoutations.create', compact('user_data', 'title', 'packages', 'services'));
    } //create

    public   function insert(Request  $request)
    {
        $customer = null;
        try {
            $customer_input = array_merge(
                // $request->all(),
                [
                    'name' => $request->name,
                    'contact' => $request->contact,
                    'id_no' => $request->id_no,
                ]
            );
            $customer = New_customers::create($customer_input);
        } //try
        catch (Exception $e) {

            $customer = New_customers::select(['*'])->where('id_no', $request->id_no)->get()->first();
        } //catch


        $input_qoutaion = array_merge(
            // $request->all(),
            [
                'customer_id' => $customer->id,
                'package_id' => $request->package,
                'event_date' => $request->date,
                'total_price' => $request->a_price,
                'vat' => $request->vat,
                'grand_total' => $request->a_price + $request->discount,
                'create_by' =>  Sentinel::getUser()->id,
                'price_after_discount' => $request->f_amount,
                'payment_status' => $request->status,
                'pending_amount' => $request->pending,

                'num_of_services' => count($request->id),
                'paid_amount' => $request->paid,
                'discount' => $request->discount,
                'terms_and_conditions' => $request->note,
                'created_timestamp' => time(),
            ]
        );


        $qoutation_id = New_qoutations::create($input_qoutaion);


        for ($x = 0; $x < count($request->id); $x++) {


            $services_input = array_merge(
                // $request->all(),
                [
                    'qoutation_id' => $qoutation_id->id,
                    'service_id' => $request->id[$x],
                    'service_name' => $request->names[$x],
                    'service_price' => $request->price[$x],
                    'qty' => $request->qty[$x],
                    't_price' => $request->s_total[$x],


                ]
            );
            New_qoutation_services::create($services_input);
        }
        // $customer = null;

        // for ($x = 0; $x < count($request->id); $x++) {


        //     $services_input = array_merge(
        //         // $request->all(),
        //         [
        //             'package_id' => $package->id,
        //             'services_id' => $request->id[$x],


        //         ]
        //     );
        //     $customer =   Services_assigned_packages::create($services_input);
        // }




        Session()->flash('flash_message', 'Created Successfully');
        return $this->index($request);
    } //insert
    //

    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('new_qoutations.index', compact('user_data'));
    } //index

    public function anyData()
    {
        $clients = New_qoutations::select(['*'])->where('new_qoutations.status', '!=', 2)->join('new_customers', 'new_customers.id', 'new_qoutations.customer_id')->get();
        // return $this->getTable($clients);
        return Datatables::of($clients)


            ->addColumn('total_price', function ($clients) {
                return $clients->total_price . ' OMR';
            })
            ->addColumn('status_string', function ($clients) {
                if ($clients->status == 1)
                    return 'Pending';
                else
                if ($clients->status == 3)
                    return 'Converted To Invoice';
                // return $clients->beneficiary_name;
            })
            ->add_column('action', '
            <div class="dropdown">
              <button class="btn" style="border-left:1px solid #0d8bf2">Actions
  
              </button>
              <div class="dropdown-content"> 
                <a href="#">View</a> 
                <a href="#">Delete</a>
              </div>
            </div>')



            ->make(true);
    }
    //
}
