<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\New_customers;
use Cartalyst\Stripe\Api\Customers;
use Illuminate\Http\Request;
use Datatables;
use Sentinel;

class NewCustomer_Controller extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->where('id', Sentinel::getUser()->id)->get()->first();
    }



    public function get_customer_info(Request $request)

    {
        $info = New_customers::select(['*'])->where([['id_no', $request->id_no], ['status', 1]])->get()->first();
        return $info;
    }







    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('new_customers.index', compact('user_data'));
    } //index

    public function anyData()
    {
        $data = New_customers::select(['*'])->where([['status', '!=', 3]])->orderBy('id', 'DESC')->get();
        // return $this->getTable($clients);
        return Datatables::of($data)


            ->addColumn('status', function ($data) {
                if ($data->status == 1)
                    return 'Active';
                else if ($data->status == 2)
                    return 'Blocked';
            })
            // ->add_column(
            //     'action',

            //     '
            // <div class="dropdown">
            //   <button class="btn" style="border-left:1px solid #0d8bf2">Actions

            //   </button>
            //   <div class="dropdown-content">
            //     <a href="#">View</a>
            //     <a href="#">De-Active</a>
            //     <a href="#">Edit</a>
            //     <a href="#">Delete</a>
            //   </div>
            // </div>'
            // )





            ->make(true);
    }
}
