<?php

namespace App\Http\Controllers;

use App\Bank_accounts;
use App\Expense_types;
use App\Expenses;
use App\Models\User;
use Sentinel;
use Illuminate\Http\Request;
use Datatables;

class ExpensesController extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->get()->first();
    }
    public   function create(Request  $request)
    {
        $all_accounts = Bank_accounts::select(['id', 'beneficiary_name'])->where([['isActive', 1], ['isDeleted', 0]])->get();
        $all_types = Expense_types::select(['*'])->where('status', 1)->get();
        $title = 'Create New Expense';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return view('expenses.create', compact('user_data', 'title', 'all_types', 'all_accounts'));
    } //create

    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('expenses.index', compact('user_data'));
    } //index




    public   function create_type(Request  $request)
    {
        $title = 'Create New Expense Category';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return view('expenses.create_type', compact('user_data', 'title'));
    } //create_type


    public   function insert_type(Request  $request)
    {

        // $title = trans('quotation.quotations');

        Expense_types::create($request->all());
        Session()->flash('flash_message', 'Created Successfully');
        return $this->create_type($request);
    } //insert_type



    public   function insert(Request  $request)
    {
        $user_data = $this->get_user_info();

        $title = 'Create New Expense';
        // $title = trans('quotation.quotations');
        $remaining = $request->expense_amount - $request->paid_amount;
        $payment_status = 1;
        if ($request->paid_amount > 0 && $request->paid_amount < $request->expense_amount)
            $payment_status = 3;
        else if ($remaining == 0)
            $payment_status = 2;

        $data = array_merge(
            $request->all(),

            [
                'payment_status' => $payment_status,
                'remaining_amount' => $remaining,
                'created_by' =>   Sentinel::getUser()->id,
            ]
        );
        Expenses::create($data);
        $all_accounts = Bank_accounts::select(['id', 'beneficiary_name'])->where([['isActive', 1], ['isDeleted', 0]])->get();
        $all_types = Expense_types::select(['*'])->where('status', 1)->get();
        $title = 'Create New Expense';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return $this->index($request);
    } //insert

    public function anyData_Categories()
    {
        $clients = Expense_types::select(['*'])->where('status', 1)->get();
        // return $this->getTable($clients);
        return Datatables::of($clients)

            ->addColumn('status', function ($clients) {
                if ($clients->status == 1)
                    return 'Active';
                else
                if ($clients->status == 0)
                    return 'De-Active';
                // return $clients->beneficiary_name;
            })
            // ->add_column('action', '
            // <div class="dropdown">
            //   <button class="btn" style="border-left:1px solid #0d8bf2">Actions

            //   </button>
            //   <div class="dropdown-content">
            //     <a href="#">Add Funds</a>
            //     <a href="#">Transfer Funds</a>
            //     <a href="#">Edit</a>
            //     <a href="#">Delete</a>
            //   </div>
            // </div>')


            // ->add_column('id', $clients->id)
            // ->add_column('price', $clients->id)
            // ->add_column('delete', '
            //     <form action="{{ route(\'clients.destroy\', $id) }}" method="POST">
            // <input type="hidden" name="_method" value="DELETE">
            // <input type="submit" name="submit" value="Delete" class="btn btn-danger" onClick="return confirm(\'Are you sure?\')"">

            // {{csrf_field()}}
            // </form>')
            ->make(true);
    }

    //
}
