<?php

namespace App\Http\Controllers;

use App\Account_transactions;
use App\Bank_accounts;
use App\Expense_types;
use App\Models\User;
use App\New_logs;
use App\New_transactions;
use App\Transaction_expenses;
use Illuminate\Http\Request;
use  Sentinel;

use Datatables;

class New_transactionsController extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->where('id', Sentinel::getUser()->id)->get()->first();
    }

    public   function create(Request  $request)
    {
        $title = 'Register Transactions';
        $user_data = $this->get_user_info();

        $expensis = Expense_types::select(['*'])->where('status', 1)->get();
        $accounts = Bank_accounts::select(['*'])->where([['isActive', 1], ['isDeleted', 0]])->get();

        // $title = trans('quotation.quotations');
        return view('transactions.create', compact('user_data', 'title', 'expensis', 'accounts'));
    } //create

    public   function insert(Request  $request)
    {
        $acc = Bank_accounts::select(['*'])->where('id', $request->account)->get()->first();
        if ($acc->current_ballance < $request->amount)
            return $this->index($request);
        $input = array_merge(
            // $request->all(),
            [
                'title' => $request->title,
                'transaction_ref_no' => $request->transaction_ref_no,
                'amount' => $request->amount,
                'decription' => $request->description,
                'created_by' => Sentinel::getUser()->id,
                'account_current_ballance' =>  $acc->current_ballance,
                'account_remaining_ballace' =>  $acc->current_ballance - $request->amount,
                'account_id' => $request->account
            ]
        );

        $trans = New_transactions::create($input);
        Bank_accounts::where('id', $request->account)->update(array('current_ballance' =>   $acc->current_ballance - $request->amount));
        $input_log = array_merge(
            // $request->all(),
            [
                'type' => 1,

                'log' => Sentinel::getUser()->name . ' has transfer ' . $request->amount . ' OMR from this account ref[' . $request->transaction_ref_no . ']. Old amount was ' . $acc->current_ballance . 'OMR and new amount is ' . $acc->current_ballance - $request->amount . ' OMR.',
                'created_by' => Sentinel::getUser()->id,

                'type_id' => $request->account,

            ]
        );

        New_logs::create($input_log);


        $acc_trans_input = array_merge(
            // $request->all(),
            [
                'account_id' => $request->account,
                'created_by' => Sentinel::getUser()->id,

                'credit' => $request->amount,
                'debit' => 0,

            ]
        );
        Account_transactions::create($acc_trans_input);
        $customer = null;

        for ($x = 0; $x < count($request->id); $x++) {


            $trans_exp_input = array_merge(
                // $request->all(),
                [
                    'transaction_id' => $trans->id,
                    'expense_id' => $request->id[$x],
                    'amount' => $request->price[$x],
                    'created_by' => Sentinel::getUser()->id,


                ]
            );
            Transaction_expenses::create($trans_exp_input);
        }




        Session()->flash('flash_message', 'Created Successfully');
        return $this->index($request);
    } //insert
    //

    public   function index(Request  $request)
    {
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('transactions.index', compact('user_data'));
    } //index

    public function anyData()
    {
        $data = New_transactions::select(['*', 'bank_accounts.beneficiary_name as account_b'])->where([['status', 1]])->join('bank_accounts', 'bank_accounts.id', 'new_transactions.account_id')->orderBy('new_transactions.id', 'DESC')->get();
        // return $this->getTable($clients);
        return Datatables::of($data)
            ->editColumn('amount', function ($data) {
                return $data->amount . ' OMR';
            })










            // ->add_column('id', $clients->id)
            // ->add_column('price', $clients->id)
            // ->add_column('delete', '
            //     <form action="{{ route(\'clients.destroy\', $id) }}" method="POST">
            // <input type="hidden" name="_method" value="DELETE">
            // <input type="submit" name="submit" value="Delete" class="btn btn-danger" onClick="return confirm(\'Are you sure?\')"">

            // {{csrf_field()}}
            // </form>')
            ->make(true);
    }
}
