<?php

namespace App\Http\Controllers;

use App\Account_transactions;
use App\Bank_accounts;
use App\Models\User;
use App\New_logs;
use Illuminate\Http\Request;
use Sentinel;
use Datatables;

class AccountsController extends Controller
{
    public function get_user_info()
    {
        return User::select(['first_name as full_name', 'user_avatar', 'id'])->get()->first();
    }
    public   function create(Request  $request)
    {
        $title = 'Add New Bank Account';
        $user_data = $this->get_user_info();
        // $title = trans('quotation.quotations');
        return view('accounts.create', compact('user_data', 'title'));
    } //create

    public function add_funds(Request $request)
    {
        $acc = Bank_accounts::select(['*'])->where([['isActive', 1], ['isDeleted', 0], ['id', $request->account]])->get()->first();
        Bank_accounts::where('id', $request->account)->update(array('current_ballance' =>   $acc->current_ballance + $request->amount));

        $amount = $acc->current_ballance + $request->amount;
        $input_log = array_merge(
            // $request->all(),
            [
                'type' => 1,

                'log' => Sentinel::getUser()->name . ' has added ' . $request->amount . ' OMR to this account ref[' . $request->ref . ']. Old amount was ' . $acc->current_ballance . 'OMR and new amount is ' .  $amount . '  OMR.',
                'created_by' => Sentinel::getUser()->id,

                'type_id' => $request->account,

            ]
        );

        New_logs::create($input_log);


        $acc_trans_input = array_merge(
            // $request->all(),
            [
                'account_id' => $request->account,
                'created_by' => Sentinel::getUser()->id,
                'ref_no' => $request->ref,
                'debit' => $request->amount,
                'credit' => 0,

            ]
        );
        Account_transactions::create($acc_trans_input);
        return $this->index($request);
    }
    public   function insert(Request  $request)
    {

        // $title = trans('quotation.quotations');
        $acc_input = array_merge(
            $request->all(),
            [
                'current_ballance' => $request->opening_ballance,

            ]
        );
        $account = Bank_accounts::create($acc_input);
        $input_log = array_merge(
            // $request->all(),
            [
                'type' => 1,

                'log' => Sentinel::getUser()->name . ' has created new account beneficairy name "' . $account->beneficiary_name . '". Opening balance is  ' . $request->opening_ballance,
                'created_by' => Sentinel::getUser()->id,

                'type_id' => $account->id,

            ]
        );
        $acc_trans_input = array_merge(
            // $request->all(),
            [
                'account_id' => $account->id,
                'created_by' => Sentinel::getUser()->id,

                'debit' => $request->opening_ballance,
                'credit' => 0,

            ]
        );
        Account_transactions::create($acc_trans_input);
        New_logs::create($input_log);
        Session()->flash('flash_message', 'Created Successfully');
        return $this->index($request);
    } //insert
    //

    public   function index(Request  $request)
    {
        $accounts = Bank_accounts::select(['*'])->where([['isActive', 1], ['isDeleted', 0]])->get();
        $user_data = $this->get_user_info();
        // $title = 'Create New Service';
        // $title = trans('quotation.quotations');
        return view('accounts.index', compact('user_data', 'accounts'));
    } //index

    public function data()
    {
        $clients = Bank_accounts::select(['*'])->get();
        // return $this->getTable($clients);
        return Datatables::of($clients)
            ->addColumn('id', function ($clients) {
                return $clients->beneficiary_name;
            })
            ->addColumn('name', function ($clients) {
                return $clients->beneficiary_name;
            })
            ->editColumn('current_ballance', function ($clients) {
                return  (string)($clients->current_ballance) . ' OMR';
            })
            ->addColumn('status_string', function ($clients) {
                if ($clients->isActive == 1)
                    return 'Active';
                else
                if ($clients->isActive == 0)
                    return 'De-Active';
                // return $clients->beneficiary_name;
            })
            ->add_column('action', '
            <div class="dropdown">
              <button class="btn" style="border-left:1px solid #0d8bf2">Actions
  
              </button>
              <div class="dropdown-content">
                <a type="button" onclick="funds_transfer();" data-toggle="modal" data-target="#add_funds" data-dismiss="modal"  >Add Funds</a> 
                <a href="#">Edit</a>
                <a href="#">Delete</a>
              </div>
            </div>')


            // ->add_column('id', $clients->id)
            // ->add_column('price', $clients->id)
            // ->add_column('delete', '
            //     <form action="{{ route(\'clients.destroy\', $id) }}" method="POST">
            // <input type="hidden" name="_method" value="DELETE">
            // <input type="submit" name="submit" value="Delete" class="btn btn-danger" onClick="return confirm(\'Are you sure?\')"">

            // {{csrf_field()}}
            // </form>')
            ->make(true);
    }
}
