@extends('layouts.user')

{{-- Web site Title --}}
@section('title')
    {{ $title }}
@stop

{{-- Content --}}
@section('content')
    <div class="page-header clearfix">
        @if($user_data->hasAccess(['products.write']) || $user_data->inRole('admin'))
            <div class="pull-right">
                <a href="{{ $type.'/create' }}" class="btn btn-primary">
                    <i class="fa fa-plus-circle"></i> {{ trans('product.create_product') }}</a>
                 <a href="{{ $type.'/import' }}" class="btn btn-primary">
                    <i class="fa fa-plus-circle"></i> {{ trans('product.import') }}</a>
            </div>
        @endif
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h4 class="panel-title">
                <i class="material-icons">layers</i>
                {{ $title }}
            </h4>
                                <span class="pull-right">
                                    <i class="fa fa-fw fa-chevron-up clickable"></i>
                                </span>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table id="data" class="table  table-bordered">
                    <thead>
                    <tr>
                        <th>{{ trans('product.product_name') }}</th>
                        <th>{{ trans('product.category_id') }}</th>
                        <th>{{ trans('product.product_type') }}</th>
                        <th>{{ trans('product.status') }}</th>
                        <th>{{ trans('product.quantity_on_hand') }}</th>
                        <th>{{ trans('product.quantity_available') }}</th>
                        <th>{{ trans('table.actions') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@stop

{{-- Scripts --}}
@section('scripts')

@stop
