@extends('layouts.user')

{{-- Web site Title --}}
@section('title')
    {{ $title }}
@stop

{{-- Content --}}
@section('content')
    <div class="page-header clearfix">
        @if($user_data->hasAccess(['logged_calls.write']) || $user_data->inRole('admin'))
            <div class="pull-right">
                <a href="{{ $type.'/create' }}" class="btn btn-primary">
                    <i class="fa fa-plus-circle"></i> {{ trans('call.create') }}</a>
            </div>
        @endif
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h4 class="panel-title">
                <i class="material-icons">phone</i>
                {{ $title }}
            </h4>
            <span class="pull-right"> <i class="fa fa-fw fa-chevron-up clickable"></i>  </span>
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered table-hover">
                        <thead>
                        <tr>
                            <th>{{ trans('call.date') }}</th>
                            <th>{{ trans('call.note') }}</th>
                            <th>{{ trans('call.duration') }}</th>
                            <th>{{ trans('call.company_name') }}</th>
                            <th>{{ trans('salesteam.main_staff') }}</th>
                            <th>{{ trans('table.actions') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

@stop

{{-- Scripts --}}
@section('scripts')

@stop