@extends('layouts.user')

{{-- Web site Title --}}

<style>
    button {
        display: block;
        border: solid white;
        border-width: 0 10px;
        border-radius: 0;
        background: green;
        color: white;
        font-size: 18px;
        margin: -60px auto 15px;
        padding: 15px;
    }

    .dropdown {
        position: absolute;
        display: inline-block;
    }

    .dropdown-content {
        display: none;
        position: absolute;
        background-color: #f1f1f1;
        min-width: 160px;
        z-index: 1;
    }

    .dropdown-content a {
        color: black;
        padding: 12px 16px;
        text-decoration: none;
        display: block;
    }

    .dropdown-content a:hover {
        background-color: #ddd
    }

    .dropdown:hover .dropdown-content {
        display: block;
    }

    .btn:hover,
    .dropdown:hover .btn {
        background-color: #0b7dda;
    }
</style>
{{-- Content --}}
@section('content')
<div class="panel panel-default">
    <div class="panel-heading">
        <h4 class="panel-title">
            <i class="material-icons">format_list_numbered_rtl</i>
            {{ 'All Bank Accounts ' }}
        </h4>
        <span class="pull-right"><i class="fa fa-fw fa-chevron-up clickable"></i></span>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="data_data" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#. </th>
                        <th>Title</th>
                        <th>Beneficiary Name</th>
                        <th>Account No.</th>
                        <th>Current Ballance</th>
                        <th>Status</th>
                        <!-- <th>Actions</th> -->

                        <!-- <th>Price </th> -->
                        <th>{{ trans('table.actions') }}</th>

                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>


    <div id="add_funds" class="modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h2>Add Funds</h2>

                    <div class="modal-body">

                        {!! Form::open([
                        'route' => 'account.add_funds'
                        ]) !!}

                        <div class="form-group"> <input id="account_no" name="account_no" type="number" hidden='true'></div>
                        <div class="form-group">
                            <label for="description_ar">
                                Select Account
                            </label>

                            <select class="select-2" name="account" id="ex2" required>
                                <?php
                                foreach ($accounts as $account) :
                                    echo '<option value="' . $account->id . '">' . $account->beneficiary_name . '</option>'; //close your tags!!
                                endforeach;
                                ?>
                            </select>
                        </div>


                        <div class="form-group ">
                            {!! Form::label('amount', 'Enter Amount:', ['class' => 'control-label']) !!}
                            {!! Form::number('amount', null, ['class' => 'form-control','required']) !!}
                        </div>
                        <div class="form-group ">
                            {!! Form::label('ref', 'Ref #.:', ['class' => 'control-label']) !!}
                            {!! Form::text('ref', null, ['class' => 'form-control','required']) !!}
                        </div>













                        {!! Form::submit('Add ', ['class' => 'btn btn-primary']) !!}
                        {!! Form::close() !!}


                    </div>

                </div>
            </div>
        </div>


        @stop
        @section('scripts')




        <script type="text/javascript" language="javascript">
            $(document).ready(function() {

                $(function() {
                    $('#data_data').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "{{ route('account.data') }}",
                            type: "GET"
                        },
                        columns: [

                            {
                                render: (data, type, row, meta) => meta.row + 1,
                            },

                            {
                                data: 'title_en',
                            },
                            {
                                data: 'beneficiary_name',
                            },

                            {
                                data: 'acc_no',
                            },



                            {
                                data: 'current_ballance',
                            },

                            {
                                data: 'status_string',
                            },


                            {
                                data: 'action',
                                name: 'action',
                                orderable: false,
                                searchable: false
                            }




                        ]
                    });
                });

            });
        </script>

        @stop